// ==UserScript==
// @name         5ch 同一ID レス数表示
// @namespace    http://tampermonkey.net/
// @version      2.1
// @description  同一data-useridのレス数を表示（postusernameの右）＆クリックでポップアップ
// @author       ChatGPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

function updateLabels() {
    const threadContainer = document.getElementById('threadcontent') || document.body;

    // 親ページのスレッド内だけの投稿を取得
    const allPosts = threadContainer.querySelectorAll('div.clear.post[data-userid]');

    const idMap = new Map();
    allPosts.forEach(post => {
        const userid = post.dataset.userid;
        if (!userid) return;
        if (!idMap.has(userid)) idMap.set(userid, []);
        idMap.get(userid).push(post);
    });

    for (const [userid, posts] of idMap.entries()) {
        const total = posts.length;

        posts.forEach((post, idx) => {
            const postusername = post.querySelector('span.postusername');
            if (!postusername) return;

            const parent = postusername.parentNode;
            if (!parent) return;

            let labelSpan = parent.querySelector(`.userid-count-label[data-id="${post.id}"]`);

            if (labelSpan) {
                labelSpan.textContent = ` [ ${idx + 1}/${total} ]`;
            } else {
                labelSpan = document.createElement('span');
                labelSpan.className = 'userid-count-label';
                labelSpan.dataset.id = post.id;
                labelSpan.dataset.userid = userid;
                labelSpan.textContent = ` [ ${idx + 1}/${total} ]`;
                labelSpan.style.cssText = `
                    font-size: 1.2em;
                    color: #888;
                    margin-left: 8px;
                    display: inline-block;
                    cursor: pointer;
                `;
                parent.insertBefore(labelSpan, postusername.nextSibling);
            }
        });
    }
}

// 初回実行
updateLabels();

// DOMの変化を監視して再適用
const threadContainer = document.getElementById('threadcontent') || document.body;
const observer = new MutationObserver(() => {
    setTimeout(updateLabels, 100);
});
observer.observe(threadContainer, { childList: true, subtree: true });
